/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _VRTYPES_H_
#define _VRTYPES_H_

extern "C" {
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <errno.h>
#include <signal.h>
#include <string.h>
#include <assert.h>
#ifdef THREADS
#include<pthread.h>
#endif
}
#include <VrComplex.h>
#include <VrCycleCount.h>
#include <iostream>
using std::cout;
using std::cerr;
using std::cin;
using std::endl;

class VrSigProc;

#ifdef THREADS
#define MUTEX_DECLARE(A) pthread_mutex_t A;
#define	MUTEX_INIT(M)	 do { if (pthread_mutex_init(M, 0) != 0) abort (); } while (0)
#define MUTEX_LOCK(M)	 pthread_mutex_lock(M)
#define MUTEX_UNLOCK(M)	 pthread_mutex_unlock(M)
#define THREAD_GETSPECIFIC(A)	pthread_getspecific(A)
extern pthread_key_t startMarkedModule;
//#define YIELD() {sched_yield();}
#define YIELD() {usleep(1);}

#else

#define MUTEX_DECLARE(A)
#define	MUTEX_INIT(M)	do {} while (0)
#define MUTEX_LOCK(M)	do {} while (0)
#define MUTEX_UNLOCK(M)	do {} while (0)
#define THREAD_GETSPECIFIC(A)	(A)
extern VrSigProc *startMarkedModule;
#define YIELD() {usleep(1);}

#endif

typedef unsigned int port;

enum {VR_NULL,VR_CHAR,VR_UCHAR,VR_SHORT,VR_INT,VR_FLOAT,VR_COMPLEX,
      VR_FRAME,VR_IPPACKET};

class VrNullData {
  int tmp;
public:
  VrNullData() {}
  VrNullData(int x) :tmp(x) {}
};

typedef char bit;
typedef VrComplex complex;
typedef unsigned char uchar;
typedef unsigned long long VrSampleIndex;
typedef struct {
	VrSampleIndex index;
	unsigned long size;
} VrSampleRange; 

inline int is_complex(VrComplex x) { return 1;}
inline int is_complex(float x) { return 0;}
inline int is_complex(double x) { return 0;}
inline int is_complex(int x) { return 0;}
inline int is_complex(char x) { return 0;}
inline int is_complex(short x) { return 0;}
#endif
