/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRMIXER_H_
#define _VRMIXER_H_

#include <VrSigProc.h>

template<class iType,class oType> 
class VrMixer : public VrSigProc {
protected:
  double freq;
  double arg;
  double argInc;
  void evaluate(int n);
  virtual void initialize();
public: 
  virtual const char *name() { return "VrMixer"; }
  virtual int work(VrSampleRange output, void *ao[],
		   VrSampleRange inputs[], void *ai[]);
  VrMixer(double f) :VrSigProc(1,sizeof(iType),sizeof(oType)),freq(f),arg(0) { }
};

template<class iType,class oType> int
VrMixer<iType,oType>::work(VrSampleRange output, void *ao[],
		VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType**)ai;
  oType **o = (iType**)ao;
  int size = output.size;
  while(size -- > 0) {
    *o[0]++ = (oType) (*i[0]++ * sin(arg));
    arg += argInc;
  }
  return output.size;
}

template<class iType,class oType> void
VrMixer<iType,oType>::initialize()  
{
  argInc = 2*M_PI*freq*(1 / (double)getInputSamplingFrequencyN(0));
}
#endif
