#ifndef _CHANNEL_H_
#define _CHANNEL_H_

#include <qwidget.h>

class QLabel;
class QwtPlot;
class QPushButton;

class Channel : public QWidget
{
  Q_OBJECT

  QLabel *label;
  QwtPlot *plot;
  QPushButton *left;
  QPushButton *right;
  
public:

  Channel(const char *labelText = 0, QWidget *p = 0, const char *name = 0);

signals:
  
  void leftClicked();
  void rightClicked();
  
public slots:

  void setLeftOn(bool on);
  void setRightOn(bool on);
  void setData(int n, double x[], double y[]);
  
};


#endif
