/* -*-c-*- --------------- mix_io.c :
 * Implementation of the functions declared in mix_io.h
 * ------------------------------------------------------------------
 * Copyright (C) 2000 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */


#include "xmix_io.h"

mix_iochannel_t *
mix_io_new (FILE *file)
{
  mix_iochannel_t *result;
  g_return_val_if_fail (file != NULL, NULL);
  result = g_new (mix_iochannel_t, 1);
  result->file = file;
  return result;
}

void
mix_io_delete (mix_iochannel_t *ch)
{
  if (ch != NULL)
    {
      fclose (ch->file);
      g_free (ch);
    }
}

FILE *
mix_io_to_FILE (mix_iochannel_t *ioc)
{
  g_return_val_if_fail (ioc != NULL, FALSE);
  return ioc->file;
}

gboolean
mix_io_eof (mix_iochannel_t *ioc)
{
  g_return_val_if_fail (ioc != NULL, FALSE);
  return is_eof_ (ioc);
}

gboolean
mix_io_is_ready (mix_iochannel_t *ioc)
{
  g_return_val_if_fail (ioc != NULL, FALSE);
  return is_ready_ (ioc);
}

gboolean
mix_io_write_byte (mix_iochannel_t *ioc, mix_byte_t b)
{
  g_return_val_if_fail (ioc != NULL, FALSE);
  return write_data_ (ioc, &b, 1);
}

gboolean
mix_io_write_byte_array (mix_iochannel_t *ioc, const mix_byte_t *b,
			 size_t s)
{
  g_return_val_if_fail (ioc != NULL, FALSE);
  g_return_val_if_fail (b != NULL, FALSE);
  return write_data_ (ioc, b, s);
}


mix_byte_t
mix_io_read_byte (mix_iochannel_t *ioc)
{
  mix_byte_t result = MIX_BYTE_ZERO;
  g_return_val_if_fail (ioc != NULL, result);
  g_return_val_if_fail (read_data_ (ioc, &result, 1), MIX_BYTE_ZERO);
  return result;
}
  
gboolean
mix_io_read_byte_array (mix_iochannel_t *ioc, mix_byte_t *b, size_t s)
{
  g_return_val_if_fail (ioc != NULL, FALSE);
  g_return_val_if_fail (b != NULL, FALSE);
  return read_data_ (ioc, b, s);
}

gboolean
mix_io_write_word (mix_iochannel_t *ioc, mix_word_t w)
{
  g_return_val_if_fail (ioc != NULL, FALSE);
  return write_data_ (ioc, &w, 1);
}

gboolean
mix_io_write_word_array (mix_iochannel_t *ioc, const mix_word_t *w,
			 size_t s)
{
  g_return_val_if_fail (ioc != NULL, FALSE);
  g_return_val_if_fail (w != NULL, FALSE);
  return write_data_ (ioc, &w, s);
}

mix_word_t
mix_io_read_word (mix_iochannel_t *ioc)
{
  mix_word_t result = MIX_WORD_ZERO;
  g_return_val_if_fail (ioc != NULL, result);
  g_return_val_if_fail (read_data_ (ioc, &result, 1), MIX_WORD_ZERO);
  return result;
}

gboolean
mix_io_read_word_array (mix_iochannel_t *ioc, mix_word_t *w, size_t s)
{
  g_return_val_if_fail (ioc != NULL, FALSE);
  g_return_val_if_fail (w != NULL, FALSE);
  return read_data_ (ioc, w, s);
}

gboolean
mix_io_write_short (mix_iochannel_t *ioc, mix_short_t w)
{
  g_return_val_if_fail (ioc != NULL, FALSE);
  return write_data_ (ioc, &w, 1);
}

gboolean
mix_io_write_short_array (mix_iochannel_t *ioc, const mix_short_t *w,
			  size_t s)
{
  g_return_val_if_fail (ioc != NULL, FALSE);
  g_return_val_if_fail (w != NULL, FALSE);
  return write_data_ (ioc, &w, s);
}

mix_short_t
mix_io_read_short (mix_iochannel_t *ioc)
{
  mix_short_t result = MIX_SHORT_ZERO;
  g_return_val_if_fail (ioc != NULL, result);
  g_return_val_if_fail (read_data_ (ioc, &result, 1), MIX_SHORT_ZERO);
  return result;
}

gboolean
mix_io_read_short_array (mix_iochannel_t *ioc, mix_short_t *w, size_t s)
{
  g_return_val_if_fail (ioc != NULL, FALSE);
  g_return_val_if_fail (w != NULL, FALSE);
  return read_data_ (ioc, w, s);
}

gboolean
mix_io_write_char (mix_iochannel_t *ioc, mix_char_t c)
{
  guchar value = mix_char_to_ascii (c);
  g_return_val_if_fail (ioc != NULL, FALSE);
  return write_data_ (ioc, &value, 1);
}

mix_char_t
mix_io_read_char (mix_iochannel_t *ioc)
{
  guchar value;
  g_return_val_if_fail (ioc != NULL, MIX_CHAR_MAX);
  g_return_val_if_fail (read_data_ (ioc, &value, 1), MIX_CHAR_MAX);
  return mix_ascii_to_char (value);
}

gboolean
mix_io_write_word_array_as_char  (mix_iochannel_t *ioc, 
				  const mix_word_t *w, size_t s)
{
  guint k, j;
  
  g_return_val_if_fail  (ioc != NULL, FALSE);
  g_return_val_if_fail (w != NULL, FALSE);
  
  for (k = 0; k < s; k++)
    for (j = 1; j < 6; j++)
      {
	mix_char_t ch = mix_word_get_byte (w[k], j);
	guchar value = mix_char_to_ascii (ch);
	if (!write_data_ (ioc, &value, 1)) return FALSE;
      }
  return TRUE;
}

gboolean
mix_io_read_word_array_as_char (mix_iochannel_t *ioc,
				mix_word_t *w, size_t s)
{
  guint k, j;
  
  g_return_val_if_fail (ioc != NULL, FALSE);
  g_return_val_if_fail (w != NULL, FALSE);

  for (k = 0; k < s; k++)
    for (j = 1; j < 6; j++)
      {
	guchar value;
	if (!read_data_ (ioc, &value, 1)) return FALSE;
	mix_word_set_byte (&w[k], j, mix_ascii_to_char (value));
      }
  return TRUE;
}
