/* $Id: taruib.h,v 1.2 2000/10/14 15:41:30 jhl Exp jhl $
   taruib.h - taru read buffer access object.
 
   Copyright (C) 2000  James H. Lowe, Jr.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef taruib_h_0930
#define taruib_h_0930

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define TARUIB_N_OTHER    		-1
#define TARUIB_N_MD5    		0
#define TARUIB_N_ADJUNCT_MD5 		1
#define TARUIB_N_SIG	 		2
#define TARUIB_N_SHA1	   		3
#define TARUIB_N_SIG_HDR		4

#define TARUIB_TEXIT_512		111
#define TARUIB_TEXIT_1024		222
#define TARUIB_TEXIT_NOT_SIGNED		15

int taruib_get_fd(void);
void taruib_set_fd(int fd);
char * taruib_get_buffer(void);
int taruib_get_datalen(void);
int taruib_get_bufferlen(void);
void taruib_set_datalen(int n);
int taruib_clear_buffer(void);
void taruib_unread(int n);
void taruib_set_overflow_release(int i);
int taruib_get_overflow_release(void);
int taruib_get_reserve(void);
int taruib_get_nominal_reserve(void);
int taruib_write_catalog_stream(void * XFORMATpackage, int ofd, int version, int verbose);
int taruib_write_storage_stream(void * XFORMATpackage, int ofd, int version, int ofd2, int verbose, int digest_type);
int taruib_write_pass_files(void * XFORMATpackage, int ofd, int adjunct_ofd_p);
int taruib_write_signedfile_if(void * vp, int ofd, char * sigfile, int verbose, int whichsig);
void taruib_initialize_pass_thru_buffer(void);
int taruib_arfcopy(void * xpackage, 
		void * xswpath, 
		int ofd, 
		char * leadingpath, 
		int do_preview, 
		unsigned long int *,
		int * deadman,
		void (*)(int));
int taruib_arfinstall(void * swi, void * xpackage, 
		void * xswpath, 
		int ofd, 
		char * leadingpath, 
		int do_preview, 
		unsigned long int *,
		int * deadman,
		void (*)(int), /*STRAR * */ void * selections);
#endif
